/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.LegendarySchemeMaker;

import LegendaryCardMaker.CardMaker;
import LegendaryCardMaker.Icon;
import LegendaryCardMaker.LegendaryCardMaker;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.LegendarySchemeMaker.BoxBlurFilter;
import LegendaryCardMaker.LegendarySchemeMaker.GaussianFilter;
import LegendaryCardMaker.LegendarySchemeMaker.HeaderIcon;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCard;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCardType;
import LegendaryCardMaker.WordDefinition;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class SchemeMaker
extends CardMaker {
    public String exportFolder = "cardCreator";
    String templateFolder = "legendary" + File.separator + "templates" + File.separator + LegendaryCardMaker.expansionStyle;
    int cardWidth = 750;
    int cardHeight = 1050;
    int dpi = 300;
    public boolean exportToPNG = true;
    public int cardNameSize = 40;
    int cardNameMinSize = 30;
    int cardNameY = 50;
    Color cardNameColor = Color.white;
    boolean includeBlurredBGName = true;
    int expandCardName = 2;
    int cardNameBlurRadius = 5;
    boolean cardNameBlurDouble = true;
    public int subCategorySize = 33;
    int subCategoryMinSize = 30;
    int subCategoryY = 85;
    Color subCategoryColor = Color.WHITE;
    boolean includeBlurredBGsubCategory = true;
    int expandSubCategory = 2;
    int subCategoryBlurRadius = 5;
    boolean subCategoryBlurDouble = true;
    public int textSize = 27;
    public int textHeaderSize = 45;
    int textY = 100;
    Color textColor = Color.BLACK;
    boolean includeBlurredBGText = false;
    int expandText = 0;
    int textBlurRadius = 0;
    boolean textBlurDouble = false;
    double textIconHeight = 1.2;
    double textGapHeight = 0.6;
    double textDefaultGapHeight = 0.2;
    int expandTextIcon = 0;
    int textIconBlurRadius = 5;
    boolean textIconBlurDouble = true;
    double rarePaddingRatio = 0.06;
    int rareBlurRadius = 25;
    public int textStartOffset = 0;
    public SchemeCard card;
    public BufferedWriter bwErr = null;

    public void setCard(SchemeCard c) {
        this.card = c;
        if (this.card.cardNameSize > 0) {
            this.cardNameSize = this.card.cardNameSize;
        }
        if (this.card.subCategorySize > 0) {
            this.subCategorySize = this.card.subCategorySize;
        }
        if (this.card.cardTextSize > 0) {
            this.textSize = this.card.cardTextSize;
        }
    }

    public void populateSchemeCard() {
        this.card = new SchemeCard();
        this.card.name = "Desertion of the Dinobots";
        this.card.subCategory = "";
        this.card.cardType = SchemeCardType.valueOf("SCHEME");
        this.card.cardText = "<k>Setup: <r>8 Twists. Hero deck must include at least 3 <DINOBOT> Heroes. <g> <k>Special Rules: <r>Heroes in City or from the Villain Deck counts as Villains with <ATTACK> equal to the Hero's <COST> +2. If you defeat the Hero, you gain it. At the start of each players turn, that player must spend <RECRUIT> equal to the number of <DINOBOT> Heroes in the HQ OR choose a <DINOBOT> to enter the City. <g> <k>Twist: <r>Each player chooses a <DINOBOT> from their hand or Discard pile and places it in the Villain Deck. Any player who cannot gains a Wound. Shuffle the Villain Deck. <g> <k>Evil Wins: <r>If 5 <DINOBOT> Heroes escape.";
    }

    public static SchemeCard getBlankSchemeCard() {
        SchemeCard card = new SchemeCard();
        card.name = "Scheme Name";
        card.subCategory = "";
        card.cardType = SchemeCardType.valueOf("SCHEME");
        card.cardText = "<k>Setup: <r> <g> <k>Twist: <r> <g> <k>Evil Wins: <r>";
        return card;
    }

    public void populateBlankSchemeCard() {
        this.card = new SchemeCard();
        this.card.name = "Scheme Name";
        this.card.subCategory = "";
        this.card.cardType = SchemeCardType.valueOf("SCHEME");
        this.card.cardText = "<k>Always Leads: <r>Villain Group <g> <k>Master Strike: <r>Some effect.";
    }

    @Override
    public BufferedImage generateCard() {
        FontMetrics metrics;
        Graphics2D g2;
        BufferedImage bi;
        int type = 2;
        if (this.exportToPNG) {
            type = 2;
        }
        BufferedImage image = new BufferedImage(this.cardWidth, this.cardHeight, type);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g = this.setGraphicsHints(g);
        if (this.card.imagePath != null) {
            String imagePath = this.card.imagePath;
            if (!imagePath.contains(File.separator) && LegendaryCardMakerFrame.lcmf.lcm.currentFile != null) {
                imagePath = String.valueOf(new File(LegendaryCardMakerFrame.lcmf.lcm.currentFile).getParent()) + File.separator + this.card.imagePath;
            }
            BufferedImage bi2 = this.resizeImage(new ImageIcon(imagePath), this.card.imageZoom);
            g.drawImage((Image)bi2, this.card.imageOffsetX, this.card.imageOffsetY, null);
        }
        if (this.card.cardText != null) {
            int y;
            BufferedImage bi3;
            block41: {
                String cardString = "";
                cardString = this.card.cardType.doesAllowHeadings() ? this.card.cardText : "<h>" + this.card.cardType.getDisplayString() + "</h>" + this.card.cardText;
                ImageIcon ii = null;
                ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "scheme" + File.separator + "scheme_text_underlay.png");
                double scale = (double)this.cardWidth / (double)ii.getIconWidth();
                bi3 = new BufferedImage(this.cardWidth, this.cardHeight, 2);
                Graphics2D g22 = this.getGraphics(bi3);
                g22.drawImage(ii.getImage(), 0, 0, this.cardWidth, this.cardHeight, null);
                y = this.textY;
                g22.setColor(this.textColor);
                try {
                    int x;
                    Font font = Font.createFont(0, new File("Swiss 721 Light Condensed.ttf"));
                    font = font.deriveFont((float)this.textSize);
                    g22.setFont(font);
                    g22 = this.setGraphicsHints(g22);
                    Font fontBold = Font.createFont(0, new File("Swiss 721 Black Condensed.ttf"));
                    fontBold = fontBold.deriveFont((float)this.textSize);
                    Font fontHeader = Font.createFont(0, new File("Percolator.otf"));
                    fontHeader = fontHeader.deriveFont((float)this.textHeaderSize);
                    FontMetrics metrics2 = g22.getFontMetrics(font);
                    int xOrigin = x = this.getPercentage(this.cardWidth, 0.05);
                    y = this.textY;
                    int xEnd = this.cardWidth - this.getPercentage(this.cardWidth, 0.05);
                    int yOrigin = this.textY;
                    System.out.println(cardString);
                    String[] sections = cardString.split("<h>");
                    boolean firstSection = true;
                    boolean lastWordWasBreak = false;
                    int lastWordBreakHeight = 0;
                    String[] stringArray = sections;
                    int n = sections.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String sectionString = stringArray[n2];
                        System.out.println("Section: " + sectionString);
                        if (!sectionString.isEmpty()) {
                            String headerStr = this.card.cardType.getDisplayString();
                            if (this.card.cardType.doesAllowHeadings()) {
                                headerStr = "";
                            }
                            HeaderIcon headerIcon = null;
                            String cardStr = sectionString;
                            if (cardStr.contains("</h>")) {
                                String[] headerSplit = sectionString.split("</h>");
                                headerStr = headerSplit[0];
                                if (headerStr.toLowerCase().contains("<hi") && headerStr.toLowerCase().contains("/>")) {
                                    String[] iconPairs;
                                    String[] spl = headerStr.split("<hi");
                                    headerStr = spl[0];
                                    String[] spl2 = spl[1].split("/>");
                                    String headerIconText = spl2[0];
                                    String[] stringArray2 = iconPairs = headerIconText.split(" ");
                                    int n3 = iconPairs.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        String i = stringArray2[n4];
                                        if (i.toUpperCase().startsWith("ICON=")) {
                                            if (headerIcon == null) {
                                                headerIcon = new HeaderIcon();
                                            }
                                            headerIcon.icon = this.isIcon(i.toUpperCase().trim().replace("ICON=", ""));
                                        }
                                        if (i.toUpperCase().startsWith("VALUE=")) {
                                            if (headerIcon == null) {
                                                headerIcon = new HeaderIcon();
                                            }
                                            headerIcon.value = i.toUpperCase().trim().replace("VALUE=", "");
                                        }
                                        ++n4;
                                    }
                                }
                                cardStr = headerSplit.length > 1 ? headerSplit[1] : "";
                            }
                            System.out.println("header: " + headerStr + ", card: " + cardStr);
                            if (headerStr != null && !headerStr.isEmpty()) {
                                int headerHeight = (int)((double)g.getFontMetrics(fontHeader).getHeight() * 1.2);
                                if (lastWordWasBreak) {
                                    y -= lastWordBreakHeight;
                                }
                                this.drawHeader(g22, headerStr.toUpperCase(), fontHeader, this.card.cardType.getBgColor(), y, headerHeight, this.getPercentage(this.cardWidth, 0.2), headerIcon);
                                y += headerHeight + metrics2.getHeight() + this.getPercentage(metrics2.getHeight(), 0.5);
                            } else if (firstSection) {
                                y += 35;
                            }
                            List<WordDefinition> words = WordDefinition.getWordDefinitionList(cardStr);
                            for (WordDefinition wd : words) {
                                String s = wd.word;
                                String spaceChar = "";
                                if (wd.space) {
                                    spaceChar = " ";
                                }
                                if (s.startsWith("<k>")) {
                                    g22.setFont(fontBold);
                                    metrics2 = g22.getFontMetrics(fontBold);
                                    s = s.replace("<k>", "");
                                    g22 = this.setGraphicsHints(g22);
                                    continue;
                                }
                                if (s.startsWith("<r>")) {
                                    g22.setFont(font);
                                    metrics2 = g22.getFontMetrics(font);
                                    s = s.replace("<r>", "");
                                    g22 = this.setGraphicsHints(g22);
                                    continue;
                                }
                                boolean gap = false;
                                if (s.equals("<g>")) {
                                    gap = true;
                                }
                                Icon icon = this.isIcon(s);
                                if (gap) {
                                    lastWordWasBreak = true;
                                    x = xOrigin;
                                    y += g22.getFontMetrics(font).getHeight() + this.getPercentage(g22.getFontMetrics(font).getHeight(), this.textGapHeight);
                                    lastWordBreakHeight = g22.getFontMetrics(font).getHeight() + this.getPercentage(g22.getFontMetrics(font).getHeight(), this.textGapHeight);
                                    continue;
                                }
                                if (icon == null) {
                                    lastWordWasBreak = false;
                                    int stringLength = SwingUtilities.computeStringWidth(metrics2, s);
                                    if (x + stringLength > xEnd) {
                                        x = xOrigin;
                                        y += g22.getFontMetrics(font).getHeight() + this.getPercentage(g22.getFontMetrics(font).getHeight(), this.textDefaultGapHeight);
                                    }
                                    g22.drawString(String.valueOf(s) + " ", x, y);
                                    x += stringLength + SwingUtilities.computeStringWidth(metrics2, spaceChar);
                                    continue;
                                }
                                if (icon == null) continue;
                                lastWordWasBreak = false;
                                BufferedImage i = this.getIconMaxHeight(icon, this.getPercentage(metrics2.getHeight(), this.textIconHeight));
                                if (x + i.getWidth() > xEnd) {
                                    x = xOrigin;
                                    y += g22.getFontMetrics(font).getHeight() + this.getPercentage(g22.getFontMetrics(font).getHeight(), this.textDefaultGapHeight);
                                }
                                double offsetRatio = this.textIconHeight - 1.0;
                                int offset = this.getPercentage(i.getHeight(), offsetRatio);
                                int modifiedY = y - i.getHeight() + offset;
                                if (icon.isUnderlayMinimized()) {
                                    this.drawUnderlay(i, g22, 2, x, modifiedY, this.textIconBlurRadius, this.textIconBlurDouble, this.expandTextIcon);
                                }
                                g22.drawImage((Image)i, x, modifiedY, null);
                                x += i.getWidth() + SwingUtilities.computeStringWidth(metrics2, spaceChar);
                            }
                            y += (int)((double)metrics2.getHeight() * 1.0);
                        }
                        firstSection = false;
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.bwErr == null) break block41;
                    try {
                        this.bwErr.write(e.getMessage());
                        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                        int n = stackTraceElementArray.length;
                        int n5 = 0;
                        while (n5 < n) {
                            StackTraceElement s = stackTraceElementArray[n5];
                            this.bwErr.write(s.toString());
                            ++n5;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            g.drawImage((Image)bi3, 0, this.cardHeight - y, null);
        }
        if (this.card.name != null) {
            bi = new BufferedImage(this.cardWidth, this.cardHeight, 2);
            g2 = this.getGraphics(bi);
            g2.setColor(this.cardNameColor);
            Font font = null;
            try {
                font = Font.createFont(0, new File("Percolator.otf"));
                font = font.deriveFont((float)this.cardNameSize);
            }
            catch (Exception e) {
                e.printStackTrace();
                font = new Font("Sylfaen", 0, this.cardNameSize);
            }
            g2.setFont(font);
            metrics = g2.getFontMetrics(font);
            int stringLength = SwingUtilities.computeStringWidth(metrics, this.card.name.toUpperCase());
            int x = this.cardWidth / 2 - stringLength / 2;
            g2 = this.setGraphicsHints(g2);
            g2.drawString(this.card.name.toUpperCase(), x, this.cardNameY);
            if (this.includeBlurredBGName) {
                this.drawUnderlay(bi, g2, type, 0, 0, this.cardNameBlurRadius, this.cardNameBlurDouble, this.expandCardName);
            }
            g2.drawString(this.card.name.toUpperCase(), x, this.cardNameY);
            g.drawImage((Image)bi, 0, 0, null);
            g2.dispose();
        }
        if (this.card.subCategory != null) {
            bi = new BufferedImage(this.cardWidth, this.cardHeight, 2);
            g2 = this.getGraphics(bi);
            g2.setColor(this.subCategoryColor);
            Font font = null;
            try {
                font = Font.createFont(0, new File("Percolator.otf"));
                font = font.deriveFont((float)this.subCategorySize);
            }
            catch (Exception e) {
                e.printStackTrace();
                font = new Font("Sylfaen", 0, this.cardNameSize);
            }
            g2.setFont(font);
            metrics = g2.getFontMetrics(font);
            int stringLength = SwingUtilities.computeStringWidth(metrics, this.card.subCategory.toUpperCase());
            int x = this.cardWidth / 2 - stringLength / 2;
            g2 = this.setGraphicsHints(g2);
            g2.drawString(this.card.subCategory.toUpperCase(), x, this.subCategoryY);
            if (this.includeBlurredBGsubCategory) {
                this.drawUnderlay(bi, g2, type, 0, 0, this.subCategoryBlurRadius, this.subCategoryBlurDouble, this.expandSubCategory);
            }
            g2.drawString(this.card.subCategory.toUpperCase(), x, this.subCategoryY);
            g.drawImage((Image)bi, 0, 0, null);
            g2.dispose();
        }
        g.dispose();
        return image;
    }

    public void exportImage(BufferedImage image) {
        try {
            if (this.exportToPNG) {
                File newFile = new File(String.valueOf(this.exportFolder) + File.separator + this.card.getCardName(this.exportFolder) + ".png");
                SchemeMaker.exportToPNG(image, newFile);
            } else {
                File newFile = new File(String.valueOf(this.exportFolder) + File.separator + this.card.getCardName(this.exportFolder) + ".jpg");
                this.exportToJPEG(image, newFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportToJPEG(BufferedImage image, File newFile) throws Exception {
        System.out.println("Exporting: " + newFile.getName());
        BufferedImage bi = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics g = bi.getGraphics();
        g.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
        File dir = new File(this.exportFolder);
        dir.mkdirs();
        ImageIO.write((RenderedImage)bi, "jpeg", newFile);
    }

    public static void exportToPNG(BufferedImage image, File newFile) throws Exception {
        System.out.println("Exporting: " + newFile.getName());
        ImageIO.write((RenderedImage)image, "png", newFile);
    }

    public BufferedImage getIcon(Icon icon, int maxWidth, int maxHeight) {
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = 1.0;
        double rX = (double)maxWidth / (double)ii.getIconWidth();
        double rY = (double)maxHeight / (double)ii.getIconHeight();
        r = rY < rX ? rY : rX;
        return this.resizeImage(ii, r);
    }

    public BufferedImage getIconMaxHeight(Icon icon, int maxHeight) {
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = (double)maxHeight / (double)ii.getIconHeight();
        return this.resizeImage(ii, r);
    }

    public int getPercentageValue(int value, int max) {
        return (int)Math.round((double)value / (double)max * 100.0);
    }

    public int getPercentage(int size, double scale) {
        return (int)((double)size * scale);
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, double scale) {
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int type = 2;
        BufferedImage image = new BufferedImage(w, h, type);
        Graphics2D g = this.getGraphics(image);
        g.drawImage(imageIcon.getImage(), 0, 0, w, h, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, int width, int height) {
        int type = 2;
        BufferedImage image = new BufferedImage(width, height, type);
        Graphics2D g = this.getGraphics(image);
        g.drawImage(imageIcon.getImage(), 0, 0, width, height, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public static ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        int i = -radius;
        while (i <= radius) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
            ++i;
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }

    private BufferedImage blackoutImage(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(image.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    image.setRGB(xx, yy, Color.BLACK.getRGB());
                }
                ++yy;
            }
            ++xx;
        }
        return image;
    }

    private void drawUnderlay(BufferedImage bi, Graphics2D g, int type, int x, int y, int blurRadius, boolean doubleBlur, int expandBlackout) {
        BufferedImage blackout = new BufferedImage(this.cardWidth, this.cardHeight, type);
        this.getGraphics(blackout).drawImage((Image)bi, x, y, null);
        blackout = this.blackoutImage(blackout);
        if (expandBlackout > 0) {
            blackout = this.expandBlackout(blackout, expandBlackout);
        }
        if (blurRadius > 0) {
            GaussianFilter op = new GaussianFilter(blurRadius);
            BufferedImage bi2 = op.filter(blackout, null);
            g.drawImage((Image)bi2, 0, 0, null);
            if (doubleBlur) {
                BufferedImage bi3 = op.filter(bi2, null);
                g.drawImage((Image)bi3, 0, 0, null);
            }
        } else {
            g.drawImage((Image)blackout, 0, 0, null);
        }
    }

    private BufferedImage blurImage(BufferedImage bi, Graphics g, int blurRadius) {
        if (blurRadius > 0) {
            GaussianFilter op = new GaussianFilter(blurRadius);
            BufferedImage bi2 = op.filter(bi, null);
            return bi2;
        }
        return bi;
    }

    private BufferedImage expandBlackout(BufferedImage image, int expandBlackout) {
        BufferedImage expand = new BufferedImage(this.cardWidth, this.cardHeight, 2);
        int width = image.getWidth();
        int height = image.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(image.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    int i = expandBlackout;
                    while (i > 0) {
                        try {
                            expand.setRGB(xx, yy - i, Color.BLACK.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx, yy + i, Color.BLACK.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx - i, yy, Color.BLACK.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx + i, yy, Color.BLACK.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (i == 1) {
                            try {
                                expand.setRGB(xx - i, yy - i, Color.BLACK.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx - i, yy + i, Color.BLACK.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx + i, yy - i, Color.BLACK.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx + i, yy + i, Color.BLACK.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        --i;
                    }
                }
                ++yy;
            }
            ++xx;
        }
        return expand;
    }

    private void listAllFonts() {
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        int i = 0;
        while (i < fonts.length) {
            System.out.println(fonts[i].getFontName());
            System.out.println(fonts[i].getName());
            System.out.println(fonts[i].getFamily());
            System.out.println(fonts[i].getAttributes().toString());
            System.out.println(fonts[i].getAvailableAttributes().toString());
            ++i;
        }
    }

    private Icon isIcon(String str) {
        block3: {
            try {
                if (str == null || str.startsWith("<") || str.endsWith(">")) break block3;
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        Icon i = Icon.valueOf(str.replace("<", "").replace(">", ""));
        return i;
    }

    private BufferedImage createRareBacking(int x, int y, int x2, int y2) {
        BufferedImage bi = new BufferedImage(this.cardWidth, this.cardHeight, 2);
        Graphics2D g2 = this.getGraphics(bi);
        g2.setColor(Color.WHITE);
        g2.fillRect(x, y, x2 - x, y2 - y);
        return bi;
    }

    private BufferedImage makeTransparent(BufferedImage bi, double percent) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(bi.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    int col = this.getPercentage(originalColor.getAlpha(), percent) << 24 | originalColor.getRed() << 16 | originalColor.getGreen() << 8 | originalColor.getBlue();
                    bi.setRGB(xx, yy, col);
                }
                ++yy;
            }
            ++xx;
        }
        return bi;
    }

    private void drawHeader(Graphics2D g, String header, Font font, Color color, int y, int height, int blurRadius, HeaderIcon headerIcon) {
        int stringLength;
        BufferedImage bi1 = new BufferedImage(this.cardWidth, this.cardHeight, 2);
        Graphics2D g2 = this.getGraphics(bi1);
        g2.setColor(color);
        g2.fillRect(0, y, this.getPercentage(this.cardWidth, 0.8), height);
        if (blurRadius > 0) {
            BoxBlurFilter op = new BoxBlurFilter();
            op.setHRadius(blurRadius);
            op.setVRadius(0);
            bi1 = op.filter(bi1, null);
            this.makeTransparent(bi1, 0.7);
        }
        g2 = this.getGraphics(bi1);
        if (headerIcon != null && headerIcon.icon != null) {
            BufferedImage bi = this.getIcon(headerIcon.icon, this.getPercentage(height, 1.9), this.getPercentage(height, 1.9));
            int iconx = this.cardWidth - this.getPercentage(this.cardWidth, 0.09) - bi.getWidth() + bi.getWidth() / 2;
            int icony = y + height / 2 - bi.getWidth() / 2;
            g2.drawImage((Image)bi, iconx, icony, null);
        }
        BufferedImage bi2 = new BufferedImage(this.cardWidth, this.cardHeight, 2);
        Graphics2D g3 = this.getGraphics(bi2);
        g3.setColor(Color.WHITE);
        g3.setFont(font);
        g3 = this.setGraphicsHints(g3);
        g3.drawString(header, this.getPercentage(this.cardWidth, 0.04), y + g.getFontMetrics(font).getHeight() - g.getFontMetrics(font).getHeight() / 6);
        if (headerIcon != null && headerIcon.value != null) {
            Font originalFont = font;
            font = font.deriveFont((float)g.getFontMetrics(originalFont).getHeight() * 1.6f);
            g3.setFont(font);
            g3 = this.setGraphicsHints(g3);
            stringLength = SwingUtilities.computeStringWidth(g.getFontMetrics(font), headerIcon.value.toUpperCase());
            g3.drawString(headerIcon.value, this.cardWidth - this.getPercentage(this.cardWidth, 0.09) - stringLength + stringLength / 2, y + g.getFontMetrics(font).getHeight() - (int)((double)g.getFontMetrics(font).getHeight() / 2.6));
            font = originalFont;
            g3.setFont(originalFont);
            g3 = this.setGraphicsHints(g3);
        }
        this.drawUnderlay(bi2, g3, 2, 0, 0, 5, true, 3);
        g3.drawString(header, this.getPercentage(this.cardWidth, 0.04), y + g.getFontMetrics(font).getHeight() - g.getFontMetrics(font).getHeight() / 6);
        if (headerIcon != null && headerIcon.value != null) {
            Font originalFont = font;
            font = font.deriveFont((float)g.getFontMetrics(originalFont).getHeight() * 1.6f);
            g3.setFont(font);
            g3 = this.setGraphicsHints(g3);
            stringLength = SwingUtilities.computeStringWidth(g.getFontMetrics(font), headerIcon.value.toUpperCase());
            g3.drawString(headerIcon.value, this.cardWidth - this.getPercentage(this.cardWidth, 0.09) - stringLength + stringLength / 2, y + g.getFontMetrics(font).getHeight() - (int)((double)g.getFontMetrics(font).getHeight() / 2.6));
            font = originalFont;
            g3.setFont(originalFont);
            g3 = this.setGraphicsHints(g3);
        }
        g.drawImage((Image)bi1, 0, 0, null);
        g.drawImage((Image)bi2, 0, 0, null);
        g2.dispose();
        g3.dispose();
    }

    public BufferedImage resizeImagePS(BufferedImage bi) {
        double scale = 2.0;
        double xPadding = 0.043;
        double yPadding = 0.08;
        String exportType = "jpg";
        ImageIcon imageIcon = new ImageIcon(bi);
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int xPad = (int)((double)imageIcon.getIconWidth() * scale * xPadding);
        int fullW = w + xPad + xPad;
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int yPad = (int)((double)imageIcon.getIconHeight() * scale * yPadding);
        int fullH = h + yPad + yPad;
        int type = 2;
        if (exportType.equals("jpg")) {
            type = 1;
        }
        BufferedImage image = new BufferedImage(fullW, fullH, type);
        Graphics2D g = this.getGraphics(image);
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, fullW, fullH);
        g.drawImage(imageIcon.getImage(), xPad, yPad, w + xPad, h + yPad, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    private Graphics2D getGraphics(BufferedImage bi) {
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return g2;
    }

    private Graphics2D setGraphicsHints(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return g2;
    }
}

